//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import "NTAG5_NFC_LIB.h"
#import "ISO15693Command.h"
#import "Utils.h"

@interface NTAG5_NFC_LIB()

@end

@implementation NTAG5_NFC_LIB

/* NFC Instances */
NFCTagReaderSession             * tagReader_session;
NSArray<__kindof id<NFCTag>>    * tags_saved;
NSObject <NFCISO15693Tag>         * NFCISO15693Tag;
bool isSessionBegin = FALSE;
int isConnected = 0;
bool checkCommandDone = false;
NSData * response;
int multiplier = 0;

#pragma mark - sharedInstance
+ (NTAG5_NFC_LIB *) sharedInstance
{
    static NTAG5_NFC_LIB *sharedInstance = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{ sharedInstance = [[NTAG5_NFC_LIB alloc] init]; });
    return sharedInstance;
}

#pragma mark - initSession
- (void) initSession:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure{
    isConnected = 0;
    if(isSessionBegin){
        isSessionBegin = false;
        [tagReader_session restartPolling];
        [self close:^(NSData *aData) {
        } onFailure:^(NSError *error) {
            NSLog(@"initSession error :\n%@", error.localizedDescription);
        }];
    }
    
    tagReader_session = [[NFCTagReaderSession alloc] initWithPollingOption:NFCPollingISO15693 delegate:self queue:dispatch_queue_create(NULL ,DISPATCH_QUEUE_CONCURRENT)];
    tagReader_session.alertMessage = @"Hold your phone near the tag to begin";
    [tagReader_session beginSession];
    isSessionBegin = TRUE;
}

#pragma mark - isConnect
- (int) isConnect{
    return isConnected;
}

#pragma mark - disconnect
- (void) close:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure{
    [tagReader_session invalidateSession];
    isConnected = 1;
}

#pragma mark - errorMessage
- (void) errorMessage:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure{
    [tagReader_session invalidateSessionWithErrorMessage:@"Communication error"];
    [tagReader_session invalidateSession];
    isConnected = 1;
}

#pragma mark - customErrorMessage
- (void) customErrorMessage: (NSString *) message message: (void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure{
    [tagReader_session invalidateSessionWithErrorMessage:message];
    isConnected = 1;
}

#pragma mark - setMessage
- (void) setMessage: (NSString *) message{
    tagReader_session.alertMessage = message;
}

#pragma mark - sendCommand
- (NSData *) sendCommand:(ISO15693Command *) command onSuccess:(void (^)(NSData *aData))success  onFailure : (void(^)(NSError *error))failure{
    
    __block NSData *commandResponse = nil;
    
    [[NTAG5_NFC_LIB sharedInstance] select: 0x2 onSuccess:^(NSData *aData) {
        
        /* ON SUCCESS CODE */
        NSLog(@"ON SUCCESS Ntag_fast_write :\n%@", aData);
        
    } onFailure:^(NSError *error) {
        /* ON FAILURE CODE */
        NSLog(@"ON FAILURE Ntag_fast_write :\n%@", error);
    }];
    
    [NFCISO15693Tag customCommandWithRequestFlag: command.flags customCommandCode: command.commandCode customRequestParameters: command.requestParameters completionHandler:^(NSData * _Nonnull response, NSError * _Nullable error) {
        
        if(response.description != nil){
            NSLog(@"Custom Command: %@ --> response: %@",[command getNSStringCommand], response.description );
            NSMutableString * sbuf = [[Utils alloc] convertNSDataBytesToHexString:response];
            NSLog(@"Custom Command Bytes: %@", sbuf);
            commandResponse = response;
            success(response);
        }else{
            [tagReader_session invalidateSession];
            NSLog(@"ERROR custom Command response: %@", error.description);
            [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {} onFailure:^(NSError *error) {}];
            commandResponse = [[NSData alloc] init];
            failure(error);
        }
    }];
    
    NSLog(@"Waiting for the response...");
    while (commandResponse == nil) {}
    NSLog(@"Response available!");
    return commandResponse;
}

#pragma mark - selectCommand
- (void) select:(uint8_t *) flags onSuccess:(void (^)(NSData *aData))success  onFailure : (void(^)(NSError *error))failure{
    
    [NFCISO15693Tag selectWithRequestFlags:2 completionHandler:^(NSError * _Nullable error) {
        NSLog(@"Select Command sent");
    }];
}


/*---------------------- TAG READER ----------------------*/

- (void) tagReaderSession:(NFCTagReaderSession *)session didDetectTags:(nonnull NSArray<__kindof id<NFCTag>> *)tags
{
    tags_saved = tags;
    
    NSLog(@"-->Tag Detected on Field");
    
    NSObject <NFCTag> * nfcTagObject = tags.firstObject;
    NSLog(@"-->MIFARE Tag Tyoe:%lu", (unsigned long)nfcTagObject.type
          );
    
    connectToTag(nfcTagObject);
}

static void connectToTag(NSObject<NFCTag> *nfcTagObject) {
    NFCISO15693Tag = nfcTagObject.asNFCISO15693Tag;
    NSLog(@"-->Connecting to Tag!");
    [tagReader_session connectToTag:NFCISO15693Tag completionHandler:^(NSError * _Nullable error) {
        if(error != nil){
            NSLog(@"%@", error.description);
            isConnected = 4;
            
            return;
        }else{
            NSLog(@"-->Connected!");
            isConnected = 3;
            tagReader_session.alertMessage = @"Hold your phone near the tag to begin";
        }
        
        NSLog(@"-->Is tag Available?");
        if(NFCISO15693Tag.isAvailable){
            NSLog(@"-->Yes, It is!");
        }
    }];
}

-(void) tagReaderSession:(NFCTagReaderSession *)session didInvalidateWithError:(NSError *)error
{
    //NSLog(@"tagReaderSession: %@", error.description);
    NSLog(@"Tag Reader Session Status: Invalidated,  %@", error.description);
    //[self initSession];
    
    isSessionBegin = false;
    [tagReader_session restartPolling];
    [self close:^(NSData *aData) {
    } onFailure:^(NSError *error) {
    }];
    
    isConnected = 4;
}

-(void)tagReaderSessionDidBecomeActive:(NFCTagReaderSession *)session{
    NSLog(@"Tag Reader Session Did Become Active response: %@", session.description);
}

@end
